# -*- coding: utf-8 -*-
"""
Created on Tue Apr 20 13:30:43 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

file_name = 'for-python.csv'
file_path = os.path.join(data_folder_path, file_name)
df = pd.read_csv(file_path)

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Box swarm plot general graphic settings"""
boxcolour = COLOURS_GREENS[650]
boxprops = {'edgecolor': boxcolour, 'linewidth': lw*1.5, 'facecolor': 'w'}
lineprops = {'color': boxcolour, 'linewidth': lw*1.5}
boxplot_kwargs = dict({'boxprops': boxprops, 'medianprops': lineprops,
                       'whiskerprops': lineprops, 'capprops': lineprops,
                       'width': 0.75})

"""Plotting the box swarm plot"""
fig = plt.figure(0)
fig.set_size_inches(14,8)
fig.set_tight_layout(True)
ax = plt.gca()

order = ['ITO', '0.5', '1', '2', '3', '5', '8', 'Glass']
sns.boxplot(x=df['Type'], y=df['Average PLQY'], ax=ax, order=order, fliersize=0, saturation=1, **boxplot_kwargs)
sns.swarmplot(x=df['Type'], y=df['Average PLQY'], ax=ax, order=order, color='w', edgecolor=boxcolour, linewidth=lw, size=8)

"""Axis details"""
ax.set_xlabel('Sample type')
ax.set_ylabel('PLQY [%]')
ax.set_ylim(bottom=0)
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(5))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(2.5))

# =============================================================================
# """Annotation"""
# ax.text(0.95, 0.95, 'ITO/TFB/LiF/Perovskite/TPBi',
#         horizontalalignment='right',
#         verticalalignment='top',
#         transform=ax.transAxes)
# =============================================================================

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
export_name = 'Plot'
plot_name = ' PLQY TFB thickness no Al2O3 box swarm'
export_name_pdf = export_name + plot_name + '.pdf'
export_name_svg = export_name + plot_name + '.svg'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path)
fig.savefig(svg_path)
plt.close(fig)

